/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.launcher.util;

import ca.infodata.launcher3.config.LauncherLogger;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Date;
import java.util.Formatter;
import java.util.List;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import javax.net.ssl.HttpsURLConnection;

public class Util {
    public static String findFileRecursive2(File root, String filename) {
        File file = Util.findFileRecursive(root, filename);
        if (file == null) {
            return null;
        }
        return file.getAbsolutePath().replace(String.valueOf(root.getAbsolutePath()) + File.separator, "");
    }

    public static String findFileNoVersionRecursive2(File root, String filename) {
        File file = Util.findFileNoVersionRecursive(root, filename);
        if (file == null) {
            return null;
        }
        return file.getAbsolutePath().replace(String.valueOf(root.getAbsolutePath()) + File.separator, "");
    }

    public static String getFileExtension(String filePath) {
        int i;
        String ext = "";
        if (filePath != null && (i = filePath.lastIndexOf(".")) != -1 && i + 1 < filePath.length()) {
            ext = filePath.substring(i + 1);
        }
        return ext;
    }

    public static boolean fileExtensionIs(String filePath, String extension) {
        if (extension != null && filePath != null) {
            return extension.equals(Util.getFileExtension(filePath));
        }
        return false;
    }

    public static File findFileNoVersionRecursive(File root, String filename) {
        if (root.getName().startsWith(filename)) {
            return root;
        }
        if (root.isDirectory()) {
            File file;
            File[] files;
            File[] fileArray = files = root.listFiles();
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                file = fileArray[n2];
                if (file.isFile() && file.getName().startsWith(filename)) {
                    return file;
                }
                ++n2;
            }
            fileArray = files;
            n = files.length;
            n2 = 0;
            while (n2 < n) {
                File f;
                file = fileArray[n2];
                if (file.isDirectory() && (f = Util.findFileNoVersionRecursive(file, filename)) != null) {
                    return f;
                }
                ++n2;
            }
        }
        return null;
    }

    public static File findFileRecursive(File root, String filename) {
        if (root.getName().equals(filename)) {
            return root;
        }
        if (root.isDirectory()) {
            File file;
            File[] files;
            File[] fileArray = files = root.listFiles();
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                file = fileArray[n2];
                if (file.isFile() && file.getName().equals(filename)) {
                    return file;
                }
                ++n2;
            }
            fileArray = files;
            n = files.length;
            n2 = 0;
            while (n2 < n) {
                File f;
                file = fileArray[n2];
                if (file.isDirectory() && (f = Util.findFileRecursive(file, filename)) != null) {
                    return f;
                }
                ++n2;
            }
        }
        return null;
    }

    public static byte[] readFileAsBytes(File file) throws IOException {
        FileInputStream is = new FileInputStream(file);
        long length = file.length();
        if (length > Integer.MAX_VALUE) {
            ((InputStream)is).close();
            throw new IOException("Could not completely read file " + file.getName());
        }
        byte[] bytes = new byte[(int)length];
        int offset = 0;
        int numRead = 0;
        while (offset < bytes.length && (numRead = ((InputStream)is).read(bytes, offset, bytes.length - offset)) >= 0) {
            offset += numRead;
        }
        if (offset < bytes.length) {
            ((InputStream)is).close();
            throw new IOException("Could not completely read file " + file.getName());
        }
        ((InputStream)is).close();
        return bytes;
    }

    public static boolean copyFile(File sourceFile, File destFile) throws IOException {
        boolean isOki = false;
        LauncherLogger.getInstance(null).log(Level.INFO, "copyFile " + sourceFile + " to " + destFile);
        if (!destFile.exists()) {
            destFile.getParentFile().mkdirs();
            destFile.createNewFile();
        }
        FileChannel source = null;
        AbstractInterruptibleChannel destination = null;
        try {
            source = new FileInputStream(sourceFile).getChannel();
            destination = new FileOutputStream(destFile).getChannel();
            ((FileChannel)destination).transferFrom(source, 0L, source.size());
            isOki = true;
        }
        finally {
            if (source != null) {
                source.close();
            }
            if (destination != null) {
                destination.close();
            }
        }
        return isOki;
    }

    public static void copyDirectory(File src, File target) throws Exception {
        File[] children;
        LauncherLogger.getInstance(null).log(Level.INFO, "copyDirectory " + src + " to " + target);
        if (src == null) {
            throw new NullPointerException("src");
        }
        if (!src.isDirectory()) {
            throw new IllegalArgumentException("src is not a directory " + src);
        }
        if (target == null) {
            throw new NullPointerException("src");
        }
        if (!target.exists()) {
            target.mkdir();
        }
        if (!target.isDirectory()) {
            throw new IllegalArgumentException("target is not a directory " + target);
        }
        File[] fileArray = children = src.listFiles();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            File child = fileArray[n2];
            if (child.isDirectory()) {
                Util.copyDirectory(child, new File(target, child.getName()));
            } else {
                Util.copyFile(child, new File(target, child.getName()));
            }
            ++n2;
        }
    }

    public static String computeMd5(File file) throws Exception {
        byte[] b = Util.readFileAsBytes(file);
        return Util.computeMd5(b);
    }

    public static String computeMd5(byte[] b) throws Exception {
        MessageDigest mD5Digest = MessageDigest.getInstance("MD5");
        mD5Digest.reset();
        mD5Digest.update(b);
        return Util.bytesToHexString(mD5Digest.digest());
    }

    public static String bytesToHexString(byte[] bytes) {
        StringBuilder sb = new StringBuilder(bytes.length * 2);
        Formatter formatter = new Formatter(sb);
        try {
            byte[] byArray = bytes;
            int n = bytes.length;
            int n2 = 0;
            while (n2 < n) {
                byte b = byArray[n2];
                formatter.format("%02x", b);
                ++n2;
            }
        }
        finally {
            formatter.close();
        }
        return sb.toString();
    }

    public static List<File> listDirectoryRecursive(File dir) {
        File[] children;
        if (dir == null) {
            throw new NullPointerException("dir");
        }
        if (!dir.isDirectory()) {
            throw new IllegalArgumentException("Le chemin ne repr\u00e9sente pas un dossier " + dir);
        }
        ArrayList<File> list = new ArrayList<File>();
        File[] fileArray = children = dir.listFiles();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            File child = fileArray[n2];
            if (child.isDirectory()) {
                list.addAll(Util.listDirectoryRecursive(child));
            } else {
                list.add(child);
            }
            ++n2;
        }
        return list;
    }

    public static boolean deleteFile(File file) {
        boolean delete = false;
        LauncherLogger.getInstance(null).log(Level.INFO, "deleting file " + file);
        if (file == null) {
            Exception e = new Exception();
            e.fillInStackTrace();
            LauncherLogger.getInstance(null).log(Level.WARNING, "trying to delete null file", e);
        } else if (file.exists() && !(delete = file.delete())) {
            LauncherLogger.getInstance(null).log(Level.WARNING, "file " + file + " was not deleted");
        }
        return delete;
    }

    public static boolean deleteDirectory(File dir) throws Exception {
        boolean allDelete = true;
        LauncherLogger.getInstance(null).log(Level.INFO, "delete directory " + dir);
        if (dir.exists()) {
            allDelete = allDelete && Util.cleanDirectory(dir);
            allDelete = allDelete && Util.deleteFile(dir);
        }
        return allDelete;
    }

    public static boolean cleanDirectory(File dir) throws Exception {
        File[] children;
        boolean allDelete = true;
        LauncherLogger.getInstance(null).log(Level.INFO, "clean directory " + dir);
        if (dir == null) {
            throw new NullPointerException("dir");
        }
        if (!dir.isDirectory()) {
            throw new IllegalArgumentException("Le chemin ne repr\u00e9sente pas un dossier " + dir);
        }
        File[] fileArray = children = dir.listFiles();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            File child = fileArray[n2];
            if (child.isDirectory()) {
                allDelete = allDelete && Util.cleanDirectory(child);
            }
            allDelete = allDelete && Util.deleteFile(child);
            ++n2;
        }
        return allDelete;
    }

    public static boolean isDirExistReadableWritable(String pathname) {
        if (Util.isBlank(pathname)) {
            return false;
        }
        File file = new File(pathname);
        return file.exists() && file.isDirectory() && file.canRead() && file.canWrite();
    }

    public static boolean isBlank(String s) {
        return s == null || s.length() == 0 || s.trim().length() == 0;
    }

    public static boolean isNotBlank(String s) {
        return !Util.isBlank(s);
    }

    public static boolean isAccessibleHttp(URL url, int timeout) {
        boolean isAccessible = false;
        try {
            URLConnection connection = url.openConnection();
            connection.setConnectTimeout(timeout);
            if (connection instanceof HttpURLConnection) {
                int code = ((HttpURLConnection)connection).getResponseCode();
                isAccessible = code != -1 ? code >= 100 && code < 300 : connection.getInputStream() != null;
            } else if (connection instanceof HttpsURLConnection) {
                int code = ((HttpsURLConnection)connection).getResponseCode();
                isAccessible = code != -1 ? code >= 100 && code < 300 : connection.getInputStream() != null;
            }
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        return isAccessible;
    }

    public static String removeSuffix(String suffix, String path) {
        suffix = suffix.replace("\\", "/");
        path = path.replace("\\", "/");
        if (suffix.charAt(suffix.length() - 1) != '/') {
            suffix = String.valueOf(suffix) + "/";
        }
        if (path.indexOf(suffix) == 0) {
            path = path.substring(suffix.length());
        }
        return path;
    }

    public static boolean isWindows() {
        String os = System.getProperty("os.name").toLowerCase();
        return os.indexOf("win") >= 0;
    }

    public static boolean isMac() {
        String os = System.getProperty("os.name").toLowerCase();
        return os.indexOf("mac") >= 0;
    }

    public static void saveToFile(File file, String content) {
        try {
            if (file.exists()) {
                Util.deleteFile(file);
            }
            FileWriter writer = new FileWriter(file);
            writer.write(content);
            writer.flush();
            writer.close();
        }
        catch (Exception e) {
            LauncherLogger.getInstance(null).log(Level.WARNING, "Failed to store " + content + " to file " + file, e);
        }
    }

    public static String readFile(File file) {
        if (file == null) {
            return null;
        }
        try {
            if (file.exists() && file.isFile() && file.canRead()) {
                return new String(Util.readFileAsBytes(file), "utf-8");
            }
        }
        catch (Exception e) {
            LauncherLogger.getInstance(null).log(Level.WARNING, "Failed to read file " + file, e);
        }
        return null;
    }

    public static void sleep(long millis) {
        try {
            TimeUnit.MILLISECONDS.sleep(millis);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public static String formatException(Throwable e) {
        String s = "";
        if (e == null) {
            s = "null";
        }
        if (e.getMessage() == null || e.getMessage().isEmpty()) {
            s = e.getClass().getName();
            if (e.getCause() != null) {
                s = String.valueOf(s) + Util.formatException(e.getCause());
            }
        } else {
            s = e.getMessage();
        }
        return s;
    }

    public static String randFileSuffix(int nbChar) {
        String s = "";
        String[] t = new String[]{"a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z", "A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z", "_", "0", "1", "2", "3", "4", "5", "6", "7", "8", "9"};
        Random rand = new Random();
        while (nbChar > 0) {
            --nbChar;
            s = String.valueOf(s) + t[rand.nextInt(t.length)];
        }
        return s;
    }

    public static List<File> listFilesFromDirectoryRecursive(File dir) {
        ArrayList<File> files = new ArrayList<File>();
        if (dir.exists() && dir.isDirectory()) {
            File[] subF;
            File[] fileArray = subF = dir.listFiles();
            int n = subF.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                if (f.isDirectory()) {
                    files.addAll(Util.listFilesFromDirectoryRecursive(f));
                } else {
                    files.add(f);
                }
                ++n2;
            }
        }
        return files;
    }

    public static String[] listFileRecursiveFromDirectory(File dir) {
        String[] list = null;
        if (dir.exists() && dir.isDirectory()) {
            ArrayList<FileView> paths = new ArrayList<FileView>();
            paths.add(new FileView(dir));
            Util.listDirRecursive(paths, dir);
            list = new String[paths.size()];
            int i = 0;
            for (FileView fv : paths) {
                list[i++] = fv.toString();
            }
        }
        return list;
    }

    private static void listDirRecursive(ArrayList<FileView> paths, File dir) {
        File[] fs;
        File[] fileArray = fs = dir.listFiles();
        int n = fs.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            paths.add(new FileView(f));
            if (f.isDirectory()) {
                Util.listDirRecursive(paths, f);
            }
            ++n2;
        }
    }

    public static String[] splitByLine(String s) {
        if (s == null) {
            return new String[0];
        }
        String separator = s.contains("\r\n") ? "\r\n" : (s.contains("\r") ? "\r" : "\n");
        return s.split(separator);
    }

    private static class FileView {
        public File file;
        public Long size;
        public Date date;
        public static int maxFileNameLength = 0;

        public FileView(File file) {
            this.file = file;
            this.size = file.getTotalSpace();
            this.date = new Date(file.lastModified());
            maxFileNameLength = Math.max(maxFileNameLength, this.file.getAbsolutePath().length());
        }

        public String toString() {
            String st = this.file.getAbsolutePath();
            while (st.length() < maxFileNameLength + 5) {
                st = String.valueOf(st) + " ";
            }
            st = String.valueOf(st) + this.date.toString() + "\t" + this.size;
            return st;
        }
    }
}

