/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.launcher3.config;

import ca.infodata.launcher.util.SyncProgressMonitor;
import ca.infodata.launcher.util.Unzip;
import ca.infodata.launcher.util.Util;
import ca.infodata.launcher3.config.ConfigFileManager;
import ca.infodata.launcher3.config.LauncherLogger;
import ca.infodata.launcher3.config.Version;
import ca.infodata.launcher3.config.VersionDiff;
import ca.infodata.launcher3.config.VersionSynchronizer;
import ca.infodata.launcher3.config.command.AbstractCommand;
import ca.infodata.launcher3.config.command.BuildBatCommand;
import ca.infodata.launcher3.config.command.BuildProxyCommand;
import ca.infodata.launcher3.config.command.ChangeLanguageCommand;
import ca.infodata.launcher3.config.command.CheckVersionCommand;
import ca.infodata.launcher3.config.command.CheckVersionCommand2;
import ca.infodata.launcher3.config.command.CreateShortCutCommand;
import ca.infodata.launcher3.config.command.HelpCommand;
import ca.infodata.launcher3.config.command.HelpCommand2;
import ca.infodata.launcher3.config.command.KnowInstallCommand;
import ca.infodata.launcher3.config.command.LaunchCommand;
import ca.infodata.launcher3.config.command.NeedNormalStreamCommand;
import ca.infodata.launcher3.config.command.NoFlushCommand;
import ca.infodata.launcher3.config.command.NoShortCutCommand;
import ca.infodata.launcher3.config.command.SkipValidationCommand;
import ca.infodata.launcher3.config.command.UpdateLauncherCommand;
import ca.infodata.launcher3.config.command.UpdateLauncherRetroCommand;
import ca.infodata.launcher3.config.command.UpdateOfysCommand;
import ca.infodata.launcher3.config.command.WaitCommand;
import ca.infodata.launcher3.download.DownloadProgressDialog;
import ca.infodata.launcher3.download.DownloadSite;
import ca.infodata.launcher3.download.MultiSiteResourceDownload;
import ca.infodata.launcher3.download.Resource;
import ca.infodata.launcher3.download.SiteProvider;
import ca.infodata.launcher3.download.StringDownload;
import ca.infodata.launcher3.download.UrlUtil;
import ca.infodata.launcher3.exception.NoMoreDownloadProdiderException;
import ca.infodata.launcher3.exception.NotToSendException;
import ca.infodata.launcher3.exception.PopupInformationException;
import ca.infodata.launcher3.exception.PopupInformationWithQuestionException;
import ca.infodata.launcher3.exception.QuietException;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Toolkit;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class Config {
    private static final String CONFIG_FILE = "ca/infodata/launcher3/ressources/config.properties";
    private static final String LAUNCHER_VERSION = "5.0";
    public static final String JAR_NAME = "OfysLauncher.jar";
    public static final String JAR_NAME_EXT = "launcher/OfysLauncher.jar";
    public static final String LANG_PROP_KEY = "osgi.nl";
    protected static Config instance;
    protected boolean haveBeenInit = false;
    protected String installFolderName;
    private boolean updateOfysCommand;
    protected Properties ofysProperties;
    protected List<AbstractCommand> commandsRegister;
    protected List<AbstractCommand> commands = new ArrayList<AbstractCommand>();
    protected static LauncherLogger logger;
    protected Properties proxyProperties;
    protected File installFolder;
    private File rootFolder;
    protected File ofysFolder;
    private File launcherFolder;
    private File updateFolder;
    private File oldUpdateFolder;
    protected SiteProvider ofysSiteProvider;
    private SiteProvider launcherSiteProvider;
    private ConfigFileManager configFileManager;
    protected Version ofysInstalledVersion;
    protected List<Version> ofysRemoteVersions;
    protected Version launcherRemoteVersion;
    public static JFrame frame;
    public static Config config;
    protected static final DownloadProgressDialog[] monitor;

    static {
        monitor = new DownloadProgressDialog[1];
    }

    public static Config getInstance(String type, String[] a) {
        if (instance == null) {
            try {
                instance = new Config(type);
                instance.init();
                instance.listCommands(a);
                instance.finishInit();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return instance;
    }

    protected Config(String type) throws Exception {
        this.ofysProperties = new Properties();
        logger = LauncherLogger.getInstance(this);
        this.setInstallFolderName(type);
    }

    public void init() throws Exception {
        if (this.haveBeenInit) {
            throw new Exception("Config have already been instanciated.");
        }
        this.commandsRegister = new ArrayList<AbstractCommand>();
        this.commandsRegister.add(new HelpCommand());
        this.commandsRegister.add(new HelpCommand2());
        this.commandsRegister.add(new ChangeLanguageCommand());
        this.commandsRegister.add(new BuildBatCommand());
        this.commandsRegister.add(new BuildProxyCommand());
        this.commandsRegister.add(new CreateShortCutCommand());
        this.commandsRegister.add(new KnowInstallCommand());
        this.commandsRegister.add(new CheckVersionCommand());
        this.commandsRegister.add(new CheckVersionCommand2());
        this.commandsRegister.add(new WaitCommand());
        this.commandsRegister.add(new LaunchCommand());
        this.commandsRegister.add(new UpdateLauncherCommand());
        this.commandsRegister.add(new UpdateLauncherRetroCommand());
        this.commandsRegister.add(new NoFlushCommand());
        this.commandsRegister.add(new NeedNormalStreamCommand());
        this.commandsRegister.add(new SkipValidationCommand());
        this.commandsRegister.add(new NoShortCutCommand());
        this.commandsRegister.add(new UpdateOfysCommand());
    }

    public static String getConfigFile() {
        return CONFIG_FILE;
    }

    public static String getLauncherVersion() {
        return LAUNCHER_VERSION;
    }

    public Properties getOfysProperties() {
        return this.ofysProperties;
    }

    public List<AbstractCommand> getCommandsRegister() {
        return this.commandsRegister;
    }

    public void setCommandsRegister(List<AbstractCommand> commandsRegister) {
        this.commandsRegister = commandsRegister;
    }

    public void setUpdateOfysCommand(boolean b) {
        this.updateOfysCommand = b;
    }

    public void finishInit() throws Exception {
        logger.init();
        logger.log("---- Parameter used for the launcher ----");
        for (AbstractCommand ac : this.commands) {
            logger.log(ac.toString());
        }
        this.initGeneralConfig();
        this.initInstallFolder();
        this.setRootFolder(new File(this.installFolder, this.getInstallFolderName()));
        this.ofysFolder = new File(this.getRootFolder(), "Ofys");
        this.setLauncherFolder(new File(this.getRootFolder(), "launcher"));
        this.setUpdateFolder(new File(this.getRootFolder(), "temp"));
        this.setOldUpdateFolder(new File(this.getRootFolder(), "update"));
        this.initProxyInfo();
        UrlUtil.trustAllHttpsServerCertificate();
        this.initLanguage();
        this.initGeneralConfigWithDistantURL();
        this.initProvider();
        this.setConfigFileManager(new ConfigFileManager(new File(this.installFolder, "Ofys")));
        this.getConfigFileManager().setConfigPropFromFoundFiles();
        this.getConfigFileManager().logConfigFiles();
    }

    protected void initProvider() throws Exception {
        String op;
        logger.log("Init download site providers...");
        String[] ops = this.ofysProperties.getProperty("ofys.download").split(";");
        this.ofysProperties.remove("ofys.download");
        ArrayList<DownloadSite> ds = new ArrayList<DownloadSite>();
        String[] stringArray = ops;
        int n = ops.length;
        int n2 = 0;
        while (n2 < n) {
            op = stringArray[n2];
            ds.add(new DownloadSite(op));
            logger.log("  Ofys site: " + op);
            ++n2;
        }
        this.ofysSiteProvider = new SiteProvider(ds);
        ops = this.ofysProperties.getProperty("launcher.download").split(";");
        this.ofysProperties.remove("launcher.download");
        ds = new ArrayList();
        stringArray = ops;
        n = ops.length;
        n2 = 0;
        while (n2 < n) {
            op = stringArray[n2];
            ds.add(new DownloadSite(op));
            logger.log("  Launcher site: " + op);
            ++n2;
        }
        this.setLauncherSiteProvider(new SiteProvider(ds));
    }

    protected void initLanguage() {
        File lgFile = new File(this.getRootFolder(), "ofys.lang");
        String lg = "fr_ca";
        if (lgFile.exists()) {
            lg = Util.readFile(lgFile);
        }
        this.ofysProperties.put(LANG_PROP_KEY, lg);
        logger.log("->Choosen langage: " + lg);
    }

    protected void initProxyInfo() throws Exception {
        File lgFile = new File(this.getRootFolder(), "proxy.prop");
        logger.log("->Check for proxy... (" + lgFile.getAbsolutePath() + ")");
        if (lgFile.exists()) {
            this.proxyProperties = new Properties();
            logger.log("\tProxy exist : loading properties.  If nothing happen after, remove the proxy file.");
            Properties p = new Properties();
            FileInputStream sras = new FileInputStream(lgFile);
            p.load(sras);
            this.proxyProperties.putAll((Map<?, ?>)p);
            for (Map.Entry<Object, Object> set : p.entrySet()) {
                if (set.getValue() == null || ((String)set.getValue()).trim().length() <= 0) continue;
                System.setProperty((String)set.getKey(), (String)set.getValue());
            }
            for (Map.Entry<Object, Object> entry : p.entrySet()) {
                logger.log("  -" + entry.getKey() + "\t:\t" + entry.getValue());
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void initInstallFolder() throws Exception {
        block25: {
            block24: {
                logger.log("Init Install Folder");
                if (!this.ofysProperties.containsKey("gmf-install")) break block24;
                logger.log("It's a gmf install.");
                File f = new File("C://infodata/");
                if (!this.isOfysInstallThere(f)) {
                    logger.log("Ofys is not install gmf in : " + f + ".");
                    logger.log("Is " + f + " base folder exist?");
                    if (!f.exists()) {
                        logger.log("No he don't: ask user if he want to create the folder:");
                        int response = JOptionPane.showConfirmDialog(null, "Ofys n'est pr\u00e9sentement pas install\u00e9 et d\u00e9sire cr\u00e9er le dossier C://Infodata/ pour poursuivre.\n\nVoulez-vous permettre \u00e0 Ofys de cr\u00e9er le dossier?");
                        System.out.println("REPONSE: " + response);
                        if (response == 0) {
                            logger.log("User wants OfysLauncher to create the folder.");
                            f.mkdir();
                            if (!f.exists()) {
                                logger.log(Level.SEVERE, "Ofys failed to create folder " + f);
                                throw new PopupInformationException("Vous avez lanc\u00e9 Ofys en mode 'GMF' et demand\u00e9 \u00e0 Ofys de cr\u00e9er le dossier " + f + ".  Cette op\u00e9ration a \u00e9chou\u00e9.  Vous devez avoir les droit d'\u00e9criture/lecture/modification sur le dossier 'C://infodata/' .  Veuillez contacter votre CSA.");
                            }
                            logger.log("OfysLauncher has created " + f + " successful!");
                        } else {
                            logger.log(Level.WARNING, "User doesn't want to create the folder. It will throw an error.");
                        }
                    } else {
                        logger.log("Yes, it exists!");
                    }
                    if (!Config.isFolderHasRight(f)) {
                        throw new PopupInformationException("Vous avez lanc\u00e9 Ofys en mode 'GMF'.  Cette op\u00e9ration a \u00e9chou\u00e9.  Vous devez avoir les droits d'\u00e9criture/lecture/modification sur le dossier 'C://infodata/' .  Veuillez contacter votre CSA.");
                    }
                    this.installFolder = f;
                    break block25;
                } else {
                    logger.log("Ofys is install.");
                    if (!Config.isFolderHasRight(f)) throw new PopupInformationException("Ofys est install\u00e9 dans " + f + " mais ne poss\u00e8de pas les droits suffisants pour se lancer correctement. Corrigez ce probl\u00e8me et relancez Ofys.");
                    this.installFolder = f;
                }
                break block25;
            }
            logger.log("It's a normal (user profile) install.");
            String homePath = System.getProperty("user.home");
            boolean canBeJH = false;
            File homeOfysFile = new File(homePath);
            if (this.isOfysInstallThere(homeOfysFile)) {
                logger.log("Ofys is install.");
                if (!Config.isFolderHasRight(homeOfysFile)) throw new PopupInformationException("Ofys est install\u00e9 dans " + homeOfysFile + " mais ne poss\u00e8de pas les droits suffisant pour se lancer correctement.  Corrigez ce probl\u00e8me et relancez Ofys.");
                this.installFolder = homeOfysFile;
            } else {
                logger.log("Ofys is not install.");
                if (Config.isFolderHasRight(homeOfysFile)) {
                    logger.log("K");
                    canBeJH = true;
                }
            }
            boolean canBeWH = false;
            File wOfysFile = null;
            if (this.installFolder == null && Util.isWindows()) {
                logger.log("On windows, check for the other home file.");
                wOfysFile = new File(System.getenv().get("USERPROFILE"));
                if (this.isOfysInstallThere(wOfysFile)) {
                    logger.log("Ofys is install.");
                    if (!wOfysFile.exists()) throw new PopupInformationException("Ofys est install\u00e9 dans " + wOfysFile + " mais ne poss\u00e8de pas les droits suffisant pour se lancer correctement.  Corrigez ce probl\u00e8me et relancez Ofys.");
                    if (!Config.isFolderHasRight(wOfysFile)) throw new PopupInformationException("Ofys est install\u00e9 dans " + wOfysFile + " mais ne poss\u00e8de pas les droits suffisant pour se lancer correctement.  Corrigez ce probl\u00e8me et relancez Ofys.");
                    this.installFolder = wOfysFile;
                } else if (!canBeJH) {
                    logger.log("Ofys is not install.");
                    if (wOfysFile.exists() && Config.isFolderHasRight(wOfysFile)) {
                        canBeWH = true;
                    }
                }
            }
            if (this.installFolder == null) {
                logger.log("Ofys is definitively not install, so we gonna look what is the best way to install.");
                if (canBeJH) {
                    this.installFolder = homeOfysFile;
                } else if (canBeWH) {
                    this.installFolder = wOfysFile;
                } else {
                    String string;
                    StringBuilder stringBuilder = new StringBuilder("Vous avez tentez de lancer Ofys dans votre r\u00e9pertoire utilisateur (").append(homeOfysFile.getAbsolutePath());
                    if (wOfysFile == null) {
                        string = "";
                        throw new PopupInformationException(stringBuilder.append(string).append(").  Vous devez avoir les droit d'\u00e9criture/lecture/modification sur votre dossier.  Veuillez contacter votre CSA. ").toString());
                    }
                    string = ", " + wOfysFile.getAbsolutePath();
                    throw new PopupInformationException(stringBuilder.append(string).append(").  Vous devez avoir les droit d'\u00e9criture/lecture/modification sur votre dossier.  Veuillez contacter votre CSA. ").toString());
                }
            }
        }
        if (!this.installFolder.exists()) {
            logger.log("Install folder '" + this.installFolder.getAbsolutePath() + "' doesn't exist. We gonna create it.");
            this.installFolder.mkdirs();
        }
        logger.log("Dossier d'installation : " + this.installFolder.getAbsolutePath() + " : " + this.installFolder.isDirectory());
    }

    public static boolean isFolderHasRight(File folder) {
        logger.log(Level.CONFIG, "isFolderHasRight checking for folder:" + folder.getAbsolutePath());
        if (folder.exists() && folder.isDirectory()) {
            logger.log(Level.CONFIG, "folder exist:" + folder.getAbsolutePath());
            File fTest = new File(folder, "accesTestFile");
            Util.saveToFile(fTest, "test");
            if (fTest.exists()) {
                logger.log(Level.CONFIG, "File test does exist:" + fTest.getAbsolutePath());
                String tt = Util.readFile(fTest);
                if ("test".equals(tt)) {
                    logger.log(Level.CONFIG, "And can read it back " + fTest.getAbsolutePath());
                    fTest.delete();
                    if (!fTest.exists()) {
                        return true;
                    }
                    logger.log(Level.CONFIG, "But cannot delete the file:" + fTest.getAbsolutePath());
                }
            } else {
                logger.log(Level.CONFIG, "But file test does not exist:" + fTest.getAbsolutePath());
            }
        }
        logger.log(Level.CONFIG, "isFolderHasRight returns false for folder:" + folder.getAbsolutePath());
        return false;
    }

    public boolean isOfysInstallThere(File folder) {
        File vFile = new File(folder, String.valueOf(this.getInstallFolderName()) + "/Ofys/ofys.version");
        logger.log("Is ofys installed here? " + vFile.exists() + " : " + vFile.getAbsolutePath());
        return vFile.exists();
    }

    public AbstractCommand getCommand(String command) {
        for (AbstractCommand ac : this.commands) {
            if (!ac.getCommandName().equals(command)) continue;
            return ac;
        }
        return null;
    }

    public File getInstallFolder() {
        return this.installFolder;
    }

    public void setInstallFolder(File installFolder) {
        this.installFolder = installFolder;
    }

    protected void initGeneralConfig() throws Exception {
        logger.log("---- Init ofys launch config ----");
        Properties p = new Properties();
        InputStream sras = this.getClass().getClassLoader().getResourceAsStream(Config.getConfigFile());
        p.load(sras);
        this.ofysProperties.putAll((Map<?, ?>)p);
        for (Map.Entry<Object, Object> entry : p.entrySet()) {
            logger.log("  -" + entry.getKey() + "\t:\t" + entry.getValue());
        }
    }

    protected void listCommands(String[] args) throws NotToSendException {
        int index = 0;
        while (index < args.length) {
            String sA = args[index];
            AbstractCommand ac = null;
            for (AbstractCommand act : this.commandsRegister) {
                if (!act.getCommandName().equals(sA)) continue;
                ac = act;
                break;
            }
            if (ac == null) {
                throw new NotToSendException("No commands exist for '" + sA + "'.  User -h or -help.");
            }
            ArrayList<String> params = new ArrayList<String>();
            while (index + 1 + params.size() < args.length) {
                String param = args[index + 1 + params.size()];
                if (!ac.isValidParameter(param)) break;
                params.add(param);
            }
            index += params.size() + 1;
            ac.setParameters(params);
            this.commands.add(ac);
        }
    }

    public Properties readPropertiesFromUrl(URL url) throws Exception {
        Properties prop = null;
        try {
            logger.log("Read index of : " + url);
            StringDownload download = new StringDownload(url, "propertiesFromUrl");
            download.setMonitor(new SyncProgressMonitor());
            download.run();
            String text = download.getString();
            Properties propTemp = new Properties();
            propTemp.load(new StringReader(text));
            if (propTemp.size() > 0) {
                prop = propTemp;
            }
        }
        catch (Exception e) {
            logger.log("Exception readPropertiesFromUrl: " + e.getMessage());
        }
        return prop;
    }

    public String readInstalledOfysDotVersion() {
        try {
            File file = Util.findFileRecursive(this.ofysFolder, "ofys.version");
            if (file != null) {
                return Util.readFile(file);
            }
        }
        catch (Exception e) {
            logger.log(Level.INFO, "Failed to read installed ofys.version cause of " + e.getMessage());
        }
        return null;
    }

    public Version getOfysInstalledVersion() throws Exception {
        if (this.ofysInstalledVersion == null) {
            this.ofysInstalledVersion = this.getInstalledVersion(this.ofysFolder);
        }
        return this.ofysInstalledVersion;
    }

    private Version getInstalledVersion(File root) throws Exception {
        List<File> localFiles = Util.listFilesFromDirectoryRecursive(root);
        Version version = new Version();
        version.name = "installed";
        version.root = root;
        version.index = new ArrayList<Resource>();
        for (File file : localFiles) {
            Resource resource = new Resource();
            resource.setPath(file.getAbsolutePath().substring(version.root.getAbsolutePath().length() + 1).replace("\\", "/"));
            resource.setMd5(Util.computeMd5(file));
            resource.setLength(file.length());
            resource.setFile(file);
            version.index.add(resource);
        }
        return version;
    }

    public List<Version> getOfysRemoteVersions() throws NoMoreDownloadProdiderException, PopupInformationWithQuestionException {
        if (this.ofysRemoteVersions == null) {
            this.ofysRemoteVersions = this.getRemoteVersions(this.ofysSiteProvider);
            if (this.ofysRemoteVersions.isEmpty()) {
                throw new PopupInformationWithQuestionException("Aucune version de ofys n'est disponible");
            }
        }
        return this.ofysRemoteVersions;
    }

    protected List<Version> getRemoteVersions(SiteProvider siteProvider) throws NoMoreDownloadProdiderException {
        MultiSiteResourceDownload download = new MultiSiteResourceDownload(siteProvider.getSites());
        String versionsTextPlain = download.downloadString(new Resource("versions.txt"));
        String[] versionNames = Util.splitByLine(versionsTextPlain);
        ArrayList<Version> versions = new ArrayList<Version>();
        String[] stringArray = versionNames;
        int n = versionNames.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            if (Util.isNotBlank(name) && !name.startsWith("#")) {
                try {
                    versions.add(this.readVersion(siteProvider, name));
                }
                catch (Exception e) {
                    logger.log(Level.WARNING, "Failed to get version " + name + ". Version will be ignored.");
                }
            }
            ++n2;
        }
        logger.log("Retrieved versions : ");
        for (Version version : versions) {
            logger.log(version.name);
        }
        return versions;
    }

    protected Version readVersion(SiteProvider siteProvider, String name) throws Exception {
        Version version = new Version();
        try {
            version.name = name;
            version.index = new ArrayList<Resource>();
            MultiSiteResourceDownload download = new MultiSiteResourceDownload(siteProvider.getSites());
            String indexTextPlain = download.downloadString(new Resource(String.valueOf(name) + "/index.txt"));
            String[] lines = Util.splitByLine(indexTextPlain);
            int i = 0;
            while (i < lines.length) {
                Resource e = new Resource();
                e.setPath(lines[i].trim());
                e.setMd5(lines[++i].trim());
                e.setLength(Long.valueOf(lines[++i].trim()));
                version.index.add(e);
                ++i;
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Failed to read index.txt of version " + name);
            throw e;
        }
        return version;
    }

    public Version getLauncherInstalledVersion() throws Exception {
        return this.getInstalledVersion(this.getLauncherFolder());
    }

    public Version getLauncherTempInstalledVersion() throws Exception {
        return this.getInstalledVersion(this.getUpdateFolder());
    }

    public Version getLauncherRemoteVersion() throws NoMoreDownloadProdiderException, PopupInformationWithQuestionException {
        if (this.launcherRemoteVersion == null) {
            List<Version> versions = this.getRemoteVersions(this.getLauncherSiteProvider());
            if (versions.isEmpty()) {
                throw new PopupInformationWithQuestionException("Aucune version du lanceur n'est disponible");
            }
            this.launcherRemoteVersion = versions.get(versions.size() - 1);
        }
        return this.launcherRemoteVersion;
    }

    public void installOfys(SyncProgressMonitor monitor, Version versionToInstall) throws Exception {
        VersionDiff diff = new VersionDiff(this.getOfysInstalledVersion(), versionToInstall);
        this.ofysInstalledVersion = null;
        VersionSynchronizer synchronizer = new VersionSynchronizer(diff);
        synchronizer.setMonitor(monitor);
        synchronizer.setSiteProvider(this.ofysSiteProvider);
        synchronizer.sync();
        this.createShortCut();
        this.getConfigFileManager().tryToFlushAllConfigs();
    }

    public void installLauncher(SyncProgressMonitor monitor) throws Exception {
        Version remote = this.getLauncherRemoteVersion();
        VersionDiff diff = new VersionDiff(this.getLauncherInstalledVersion(), remote);
        VersionSynchronizer synchronizer = new VersionSynchronizer(diff);
        synchronizer.setMonitor(monitor);
        synchronizer.setSiteProvider(this.getLauncherSiteProvider());
        synchronizer.sync();
    }

    public void sync(VersionDiff diff, SiteProvider siteProvider, SyncProgressMonitor monitor) throws Exception {
        VersionSynchronizer synchronizer = new VersionSynchronizer(diff);
        synchronizer.setMonitor(monitor);
        synchronizer.setSiteProvider(siteProvider);
        synchronizer.sync();
    }

    public void saveLangageFile() {
        File lgFile = new File(this.getRootFolder(), "ofys.lang");
        boolean mustSave = false;
        if (lgFile.exists()) {
            String lg = Util.readFile(lgFile);
            if (!lg.equals(this.ofysProperties.get(LANG_PROP_KEY))) {
                mustSave = true;
                lgFile.delete();
            }
        } else {
            mustSave = true;
        }
        if (mustSave) {
            Util.saveToFile(lgFile, (String)this.ofysProperties.get(LANG_PROP_KEY));
        }
        logger.log("->Save new choosen langage: " + this.ofysProperties.get(LANG_PROP_KEY));
    }

    public void createShortCut() throws Exception {
        logger.log(Level.INFO, "####################");
        logger.log(Level.INFO, "---->create shortcut");
        logger.log(Level.INFO, "####################");
        File avoidShortcutFile = new File(this.getRootFolder(), "no-shortcut.flag");
        if (avoidShortcutFile.exists()) {
            logger.log(Level.INFO, "\tNo shortcut flag found : wont create the shortcut.");
        } else if (Util.isWindows()) {
            String vbs = " Dim WSHShell\n Set WSHShell = _\n    WScript.CreateObject(\"WScript.Shell\")\n Dim MyShortcut, MyDesktop, DesktopPath\n ' Read desktop path using WshSpecialFolders object\n DesktopPath = _\n    WSHShell.SpecialFolders(\"Desktop\")\n ' Create a shortcut object on the desktop\n Set MyShortcut = _\n    WSHShell.CreateShortcut( _\n    DesktopPath & \"\\" + this.getInstallFolderName() + ".lnk\")\n" + " ' Set shortcut object properties and save it\n" + " MyShortcut.TargetPath = _\n" + "    WSHShell.ExpandEnvironmentStrings( _\n" + "    \"\"\"" + this.getLauncherFolder().getAbsolutePath() + "\\" + JAR_NAME + "\"\"\")\n" + " MyShortcut.WorkingDirectory = _\n" + "    WSHShell.ExpandEnvironmentStrings( _\n" + "    \"" + this.ofysFolder.getAbsolutePath() + "\")\n" + " MyShortcut.WindowStyle = 4\n" + " MyShortcut.IconLocation = _\n" + "    WSHShell.ExpandEnvironmentStrings( _\n" + "    \"" + this.ofysFolder.getAbsolutePath() + "\\appIcon.ico\")\n" + " MyShortcut.Save\n";
            File f = new File(this.installFolder, "shortcut.vbs");
            Util.saveToFile(f, vbs);
            logger.log(Level.INFO, "---->createShortCut Windows");
            try {
                String cmd = "wscript \"" + f.getAbsolutePath() + "\"";
                logger.log("CMD :" + cmd);
                Process proc = Runtime.getRuntime().exec(cmd);
                proc.waitFor();
                f.deleteOnExit();
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, e);
            }
        } else {
            logger.log(Level.INFO, "---->createShortCut Mac");
            File fAppZip = new File(this.ofysFolder, "ofysApp.zip");
            if (fAppZip.exists()) {
                Unzip.unzip(fAppZip, this.getRootFolder());
            }
            File fApp = new File(this.getRootFolder(), "ofys.app");
            File desktopFile = new File(System.getProperty("user.home", ""), "Desktop");
            logger.log(Level.INFO, "From " + fApp + " to " + desktopFile);
            if (fApp.exists() && desktopFile.exists()) {
                try {
                    File macosxFolder;
                    logger.log(Level.INFO, "COPY");
                    File fDesktopApp = new File(desktopFile, String.valueOf(this.getInstallFolderName()) + ".app");
                    Util.copyDirectory(fApp, fDesktopApp);
                    logger.log(Level.INFO, "AJUST RIGHTS");
                    String[] cmd1 = new String[]{"chmod", "-R", "777", fApp.getAbsolutePath()};
                    String[] cmd2 = new String[]{"chmod", "-R", "777", fDesktopApp.getAbsolutePath()};
                    logger.log(Level.INFO, "CMD1 :" + Config.getStringOfTableCmd(cmd1));
                    Process proc = Runtime.getRuntime().exec(cmd1);
                    proc.waitFor();
                    logger.log(Level.INFO, "CMD2 :" + Config.getStringOfTableCmd(cmd2));
                    Process proc2 = Runtime.getRuntime().exec(cmd2);
                    proc2.waitFor();
                    File olPathFile = new File(desktopFile, String.valueOf(this.getInstallFolderName()) + ".app/Contents/Resources/script");
                    if (olPathFile.exists()) {
                        String contains = Util.readFile(olPathFile);
                        contains = contains.replace("PATH_OFYS_LAUNCHER", String.valueOf(this.getRootFolder().getAbsolutePath()) + "/" + JAR_NAME_EXT);
                        Util.saveToFile(olPathFile, contains);
                    }
                    if ((macosxFolder = new File(this.getRootFolder(), "__MACOSX")).exists()) {
                        String[] cmd3 = new String[]{"chmod", "-R", "777", macosxFolder.getAbsolutePath()};
                        logger.log(Level.INFO, "CMD3 :" + Config.getStringOfTableCmd(cmd3));
                        Process proc3 = Runtime.getRuntime().exec(cmd3);
                        proc3.waitFor();
                        Util.deleteDirectory(macosxFolder);
                    }
                    logger.log(Level.INFO, "DELETE");
                    Util.deleteFile(fApp);
                }
                catch (Exception e) {
                    logger.log(Level.INFO, e);
                }
            } else {
                logger.log(Level.SEVERE, "Impossible de d\u00e9compresser " + fAppZip.getAbsolutePath() + ":" + fAppZip.exists() + "/" + fApp.exists() + "/" + desktopFile.exists());
                throw new Exception("Impossible de d\u00e9compresser " + fAppZip.getAbsolutePath() + ".");
            }
        }
    }

    protected static String getStringOfTableCmd(String[] t) {
        String s = "";
        String[] stringArray = t;
        int n = t.length;
        int n2 = 0;
        while (n2 < n) {
            String ss = stringArray[n2];
            s = String.valueOf(s) + " " + ss;
            ++n2;
        }
        return s;
    }

    protected void initGeneralConfigWithDistantURL() throws Exception {
        logger.log("---- Init ofys launch config with distanct URL----");
        String relais = this.ofysProperties.getProperty("relais");
        logger.log("*** relais = " + relais);
        if (Util.isNotBlank(relais)) {
            String[] rels;
            String[] stringArray = rels = relais.split(";");
            int n = rels.length;
            int n2 = 0;
            while (n2 < n) {
                String r = stringArray[n2];
                URL url = new URL(r);
                Properties props = this.readPropertiesFromUrl(url);
                if (props != null) {
                    logger.log("Relais file found to " + url);
                    String isActive = props.getProperty("active");
                    logger.log("  *isActive?" + isActive);
                    if (!"true".equalsIgnoreCase(isActive)) break;
                    this.ofysProperties.putAll((Map<?, ?>)props);
                    logger.log(Level.WARNING, "Server is down or Relais config simply activated to launch ofys at :" + url);
                    logger.log("  Properties overridden:");
                    for (Map.Entry<Object, Object> entry : props.entrySet()) {
                        logger.log("    -" + entry.getKey() + "\t:\t" + entry.getValue());
                    }
                    break;
                }
                logger.log("Relais file NOT found (" + url + ")");
                ++n2;
            }
        }
        logger.log("FINAL RESULT: ");
        for (Map.Entry<Object, Object> entry : this.ofysProperties.entrySet()) {
            logger.log("  -" + entry.getKey() + "\t:\t" + entry.getValue());
        }
    }

    public String getInstallFolderName() {
        return this.installFolderName;
    }

    public void setInstallFolderName(String installFolderName) {
        this.installFolderName = installFolderName;
    }

    public File getUpdateFolder() {
        return this.updateFolder;
    }

    public void setUpdateFolder(File updateFolder) {
        this.updateFolder = updateFolder;
    }

    public File getOldUpdateFolder() {
        return this.oldUpdateFolder;
    }

    public void setOldUpdateFolder(File oldUpdateFolder) {
        this.oldUpdateFolder = oldUpdateFolder;
    }

    public File getLauncherFolder() {
        return this.launcherFolder;
    }

    public void setLauncherFolder(File launcherFolder) {
        this.launcherFolder = launcherFolder;
    }

    public File getRootFolder() {
        return this.rootFolder;
    }

    public void setRootFolder(File rootFolder) {
        this.rootFolder = rootFolder;
    }

    public ConfigFileManager getConfigFileManager() {
        return this.configFileManager;
    }

    public void setConfigFileManager(ConfigFileManager configFileManager) {
        this.configFileManager = configFileManager;
    }

    public boolean isUpdateOfysCommand() {
        return this.updateOfysCommand;
    }

    public SiteProvider getLauncherSiteProvider() {
        return this.launcherSiteProvider;
    }

    public void setLauncherSiteProvider(SiteProvider launcherSiteProvider) {
        this.launcherSiteProvider = launcherSiteProvider;
    }

    protected static void cleanUpdateFolder() throws Exception {
        File f2;
        File f = config.getUpdateFolder();
        if (f.exists() && !Util.deleteDirectory(f)) {
            logger.log(Level.WARNING, "Unable to remove temporary launcher in " + f.getAbsolutePath());
        }
        if ((f2 = config.getOldUpdateFolder()).exists() && !Util.deleteDirectory(f2)) {
            logger.log(Level.WARNING, "Unable to remove temporary launcher in " + f2.getAbsolutePath());
        }
    }

    protected static void updateLauncher() throws Exception {
        String sPath = System.getProperty("java.class.path");
        File oFile = new File(sPath);
        File dFile = new File(config.getLauncherFolder(), JAR_NAME);
        if (dFile.exists() && !dFile.delete() || !oFile.exists()) {
            logger.log(Level.WARNING, "Failed to delete at first attemp " + dFile.getAbsolutePath() + " (" + dFile.exists() + ") or does not exist (" + oFile.exists() + ") " + oFile.getAbsolutePath());
            Thread.sleep(3000L);
            if (dFile.exists() && !dFile.delete() || !oFile.exists()) {
                logger.log(Level.SEVERE, "Failed to delete " + dFile.getAbsolutePath() + " (" + dFile.exists() + ") or does not exist (" + oFile.exists() + ") " + oFile.getAbsolutePath());
                throw new PopupInformationException("Impossible de mettre \u00e0 jour le Lanceur Ofys.");
            }
        }
        oFile.deleteOnExit();
        if (!Util.copyFile(oFile, dFile)) {
            logger.log(Level.SEVERE, "Failed to copy " + oFile.getAbsolutePath() + " to " + dFile.getAbsolutePath());
            throw new PopupInformationException("Impossible de mettre \u00e0 jour le Lanceur Ofys.");
        }
        if (!dFile.exists()) {
            logger.log(Level.SEVERE, "Failed to copy somehow " + oFile.getAbsolutePath() + " to " + dFile.getAbsolutePath());
            throw new PopupInformationException("Impossible de mettre \u00e0 jour le Lanceur Ofys.");
        }
        logger.log(String.valueOf(dFile.getAbsolutePath()) + " is now existing!");
    }

    protected static void checkLauncher() throws Exception {
        boolean isOki = false;
        boolean hasCheckValid = false;
        File launcher = new File(config.getLauncherFolder(), JAR_NAME);
        logger.log("--> Check if launcher is valid (" + launcher.getAbsolutePath() + ")");
        if (launcher.exists()) {
            hasCheckValid = true;
            if (Config.isLauncherValid()) {
                isOki = true;
            }
        }
        logger.log("launcher is oki? " + isOki);
        logger.log("launcher is checked? " + hasCheckValid);
        if (!isOki) {
            if (!hasCheckValid) {
                Config.isLauncherValid();
            }
            if (launcher.exists() && !launcher.delete()) {
                Config.downloadAndRelaunchLauncher();
            }
            Config.installLauncher();
        }
    }

    public static void launchOfys() throws Exception {
        Process proc;
        File bat;
        config.saveLangageFile();
        File ofysDir = config.getRootFolder();
        logger.log("Lancement d'Ofys");
        String options = "";
        String javaExe = "java.exe";
        String binFolder = "";
        String[] searchJavaFolder = null;
        if (Util.isWindows()) {
            options = String.valueOf(options) + "-Xms256m -Xmx896m";
            searchJavaFolder = new String[]{"C:/Program Files/Zulu", "C:/Program Files/Java", "C:/Program Files (x86)/Java"};
            binFolder = "/bin/";
        } else if (Util.isMac()) {
            options = String.valueOf(options) + " -XstartOnFirstThread -Xms256m -Xmx896m -XX:MaxPermSize=256m -Xdock:icon=\"" + ofysDir + "/Ofys/appIcon.icns\" -Dorg.eclipse.swt.internal.carbon.smallFonts";
            searchJavaFolder = new String[]{"/Library/Java/JavaVirtualMachines"};
            binFolder = "/Contents/Home/bin/";
            javaExe = "java";
        }
        if (searchJavaFolder == null) {
            logger.log(Level.SEVERE, "----- > searchJavaFolder is null (is not windows nor mac!) < ---------");
            return;
        }
        boolean foundIt = false;
        String[] stringArray = searchJavaFolder;
        int n = searchJavaFolder.length;
        int n2 = 0;
        while (n2 < n) {
            void jf = stringArray[n2];
            logger.log(Level.INFO, "Looking for Java in: " + (String)jf);
            File file = new File((String)jf);
            if (file.isDirectory()) {
                File[] arrFiles = file.listFiles();
                ArrayList<File> lstFiles = new ArrayList<File>();
                lstFiles.addAll(Arrays.asList(arrFiles));
                lstFiles.sort(new Comparator<File>(){

                    @Override
                    public int compare(File o1, File o2) {
                        if (o1.lastModified() > o2.lastModified()) {
                            return -1;
                        }
                        if (o1.lastModified() < o2.lastModified()) {
                            return 1;
                        }
                        return 0;
                    }
                });
                for (File ff : lstFiles) {
                    String f = ff.getName();
                    logger.log(Level.INFO, "Java found:" + f);
                    if (f.indexOf("zulu-8") <= -1 && f.indexOf("1.8.0") <= -1 || !new File(javaExe = String.valueOf(jf) + "/" + f + binFolder + javaExe).exists()) continue;
                    foundIt = true;
                    logger.log(Level.INFO, "Java selected: " + javaExe);
                    javaExe = "\"" + javaExe + "\"";
                    break;
                }
            }
            if (foundIt) break;
            ++n2;
        }
        HashMap<String, String> env = new HashMap<String, String>();
        env.put("osgi.bundles", "javax.annotation@1:start,javax.annotation-api@1:start,org.eclipse.equinox.ds@1:start,org.eclipse.osgi.services@1:start,org.eclipse.osgi.util@1:start,org.apache.felix.scr@1:start,javax.ws.rs.jsr311-api@-1:start,com.sun.jersey.core@1:start,com.sun.jersey.client@1:start,com.sun.jersey.contribs.jersey-apache-client4@1:start,org.eclipse.equinox.common@2:start,org.eclipse.osgi@-1:start,org.eclipse.update.configurator@3:start,org.eclipse.core.runtime@start");
        env.put("osgi.clean", "true");
        env.put("osgi.configuration.area", ofysDir + Config.config.getConfigFileManager().configFileName);
        env.put("osgi.instance.area", ofysDir + "/instance");
        env.put("osgi.sharedConfiguration.area", ofysDir + "/shared");
        env.put("osgi.user.area", ofysDir + "/user");
        env.put("eclipse.ee.install.verify", "true");
        env.put("eclipse.product", "ca.infodata.ofys.ui.intro.product");
        env.put("osgi.splashPath", "platform:/base/plugins/ca.infodata.ofys.ui.intro");
        config.getOfysProperties().putAll((Map<?, ?>)env);
        ArrayList<String> classpath = new ArrayList<String>();
        String launcherJar = Util.findFileNoVersionRecursive2(ofysDir, "org.eclipse.equinox.launcher_");
        classpath.add(launcherJar);
        StringBuilder commandBuilder = new StringBuilder(1000);
        commandBuilder.append(javaExe);
        commandBuilder.append(" ").append(options);
        for (Map.Entry entry : config.getOfysProperties().entrySet()) {
            commandBuilder.append(" -D").append(entry.getKey()).append("=\"").append(entry.getValue()).append("\"");
        }
        commandBuilder.append(" -classpath \"");
        for (String string : classpath) {
            commandBuilder.append(string).append(";");
        }
        commandBuilder.deleteCharAt(commandBuilder.length() - 1);
        commandBuilder.append("\" ");
        String string = "org.eclipse.equinox.launcher.Main";
        commandBuilder.append(" ").append(string).append(" ");
        commandBuilder.append(" -name " + ofysDir + " -persistState false -clearPersistedState");
        if (Util.isWindows()) {
            commandBuilder.append(" -showsplash");
        } else if (Util.isMac()) {
            commandBuilder.append(" -nosplash");
        }
        String command = commandBuilder.toString();
        logger.log(Level.INFO, "----- > LAUNCH OFYS WITH < ---------");
        logger.log(Level.INFO, "applicationDir=" + ofysDir.getAbsolutePath());
        logger.log(Level.INFO, "command=" + command);
        if (Util.isMac()) {
            if (Config.haveCommand("-build-bat")) {
                bat = new File(ofysDir, "/" + config.getInstallFolderName() + ".sh");
                Util.saveToFile(bat, command);
            }
            File file = File.createTempFile("launch", "sh");
            String script = "cd \"" + ofysDir.getAbsolutePath() + "\"\n" + command.toString() + "\n";
            Util.saveToFile(file, script);
            file.setExecutable(true);
            proc = Runtime.getRuntime().exec(new String[]{"/bin/sh", file.getAbsolutePath()});
        } else {
            if (Config.haveCommand("-build-bat")) {
                bat = new File(ofysDir, "/" + config.getInstallFolderName() + ".bat");
                Util.saveToFile(bat, command);
            }
            proc = Runtime.getRuntime().exec(command, null, ofysDir);
        }
        logger.log(Level.INFO, "----- > LAUNCH OFYS WITH FIN < ---------");
    }

    public static void installOfys() throws Exception {
        Exception ex;
        block11: {
            final boolean isInstall = config.isOfysInstallThere(config.getInstallFolder());
            Config.checkAndFlagDownloading();
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    DownloadProgressDialog d = new DownloadProgressDialog();
                    if (!isInstall) {
                        d.setDialogTitleInstall();
                    }
                    Config.monitor[0] = d;
                    d.getDialog().setLocationRelativeTo(null);
                    d.getDialog().setAlwaysOnTop(true);
                    d.getDialog().setVisible(true);
                }
            });
            ex = null;
            try {
                try {
                    List<Version> versions = config.getOfysRemoteVersions();
                    Version version = null;
                    if (config.isUpdateOfysCommand()) {
                        version = versions.get(versions.size() - 1);
                    } else {
                        String installedVersionName = config.readInstalledOfysDotVersion();
                        if (installedVersionName != null) {
                            for (Version version2 : versions) {
                                if (!installedVersionName.equals(version2.name)) continue;
                                version = version2;
                                break;
                            }
                        }
                        if (version == null) {
                            version = versions.get(versions.size() - 1);
                        }
                    }
                    config.installOfys(monitor[0], version);
                }
                catch (Exception e) {
                    ex = e;
                    SwingUtilities.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            monitor[0].getDialog().dispose();
                        }
                    });
                    break block11;
                }
            }
            catch (Throwable throwable) {
                SwingUtilities.invokeAndWait(new /* invalid duplicate definition of identical inner class */);
                throw throwable;
            }
            SwingUtilities.invokeAndWait(new /* invalid duplicate definition of identical inner class */);
        }
        if (ex != null) {
            throw ex;
        }
    }

    public static void checkAndFlagDownloading() throws Exception {
        File flagFile = new File(config.getRootFolder(), "installFlag.ofys");
        if (flagFile.exists()) {
            String contain = Util.readFile(flagFile);
            long flagTime = Long.parseLong(contain);
            long diff = System.currentTimeMillis() - flagTime;
            if (diff < 120000L) {
                logger.log(Level.SEVERE, "Try to launch twice the install!");
                throw new PopupInformationException("Une autre instance du lanceur est d\u00e9j\u00e0 en train d'installer ou de mettre \u00e0 jour Ofys.");
            }
            Util.saveToFile(flagFile, "" + System.currentTimeMillis());
            flagFile.deleteOnExit();
        } else {
            Util.saveToFile(flagFile, "" + System.currentTimeMillis());
            flagFile.deleteOnExit();
        }
    }

    public static void installLauncher() throws Exception {
        Exception ex;
        block6: {
            logger.log("-->Install launcher");
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    DownloadProgressDialog d = new DownloadProgressDialog();
                    d.setDialogTitleInstall();
                    Config.monitor[0] = d;
                    d.getDialog().setLocationRelativeTo(null);
                    d.getDialog().setAlwaysOnTop(true);
                    d.getDialog().setVisible(true);
                }
            });
            ex = null;
            try {
                try {
                    config.installLauncher(monitor[0]);
                }
                catch (Exception e) {
                    ex = e;
                    SwingUtilities.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            monitor[0].getDialog().dispose();
                        }
                    });
                    break block6;
                }
            }
            catch (Throwable throwable) {
                SwingUtilities.invokeAndWait(new /* invalid duplicate definition of identical inner class */);
                throw throwable;
            }
            SwingUtilities.invokeAndWait(new /* invalid duplicate definition of identical inner class */);
        }
        if (ex != null) {
            throw ex;
        }
    }

    public static void downloadAndRelaunchLauncher() throws Exception {
        logger.log("-- Will relauncher from somewhere else to be able to install launcher.");
        SwingUtilities.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                DownloadProgressDialog d;
                Config.monitor[0] = d = new DownloadProgressDialog();
                d.getDialog().setLocationRelativeTo(null);
                d.getDialog().setAlwaysOnTop(true);
                d.getDialog().setVisible(true);
            }
        });
        Exception ex = null;
        try {
            try {
                Version local = config.getLauncherInstalledVersion();
                Version localTemp = config.getLauncherTempInstalledVersion();
                Version remote = config.getLauncherRemoteVersion();
                if (new VersionDiff(local, remote).noDiff()) {
                    throw new QuietException("We are in process to download launcher for update and there is no file in launcherDiff.. Something gone wrong!");
                }
                logger.log("Will relaunch from " + localTemp.root.getAbsolutePath());
                VersionDiff diff = new VersionDiff(localTemp, remote);
                diff.setDeleteAllDownloadAll();
                config.sync(diff, config.getLauncherSiteProvider(), monitor[0]);
                File jar = Util.findFileRecursive(localTemp.root, JAR_NAME);
                if (jar == null) {
                    throw new QuietException("Unable to find OfysLauncher.jar file in root " + localTemp.root);
                }
                String cmd = "java -jar " + jar.getName() + " -wait -update-launcher";
                Runtime.getRuntime().exec(cmd, null, jar.getParentFile());
                throw new NotToSendException("Relaunching to update...");
            }
            catch (Exception e) {
                ex = e;
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        monitor[0].getDialog().dispose();
                    }
                });
            }
        }
        catch (Throwable throwable) {
            SwingUtilities.invokeAndWait(new /* invalid duplicate definition of identical inner class */);
            throw throwable;
        }
        if (ex != null) {
            throw ex;
        }
    }

    protected static boolean isInstallValid() throws Exception {
        return Config.isInstallValid(false);
    }

    protected static boolean isInstallValid(boolean throwErrorOnFalse) throws Exception {
        ArrayList<VersionDiff> diffs;
        block14: {
            Version installedVersion = config.getOfysInstalledVersion();
            List<Version> versions = config.getOfysRemoteVersions();
            diffs = new ArrayList<VersionDiff>();
            boolean valid = false;
            if (config.isUpdateOfysCommand()) {
                Version version = versions.get(versions.size() - 1);
                VersionDiff diff = new VersionDiff(installedVersion, version);
                diffs.add(diff);
                valid = diff.noDiff();
                if (valid) {
                    logger.log("installed version found valid with " + version);
                } else {
                    logger.log("installed version diff with " + diff);
                }
            } else {
                Iterator<Version> iterator = versions.iterator();
                while (!valid && iterator.hasNext()) {
                    Version version = iterator.next();
                    VersionDiff diff = new VersionDiff(installedVersion, version);
                    diffs.add(diff);
                    if (diff.noDiff()) {
                        valid = true;
                        logger.log("installed version found valid with " + version);
                        continue;
                    }
                    logger.log("installed version diff with " + diff);
                }
            }
            if (!valid) break block14;
            return true;
        }
        try {
            if (throwErrorOnFalse) {
                VersionDiff versionComparator = (VersionDiff)diffs.get(0);
                String files = "L'installation ou la mise-\u00e0-jour de Ofys a \u00e9chou\u00e9.\n\n\u00c0 supprimer (" + versionComparator.toDelete.size() + ":\n";
                for (Resource f : versionComparator.toDelete) {
                    files = String.valueOf(files) + "\t" + (f.getPath() == null ? "" : f.getPath()) + "\n";
                }
                files = String.valueOf(files) + "\u00c0 mettre \u00e0 t\u00e9l\u00e9charger (" + versionComparator.toDownload.size() + "):\n";
                for (Resource f : versionComparator.toDownload) {
                    files = String.valueOf(files) + "\t" + (f.getPath() == null ? "" : f.getPath()) + "\n";
                }
                logger.log(Level.SEVERE, "Installation is still not valid after update/install ofys.\n" + files);
                throw new PopupInformationException(files);
            }
        }
        catch (NoMoreDownloadProdiderException e) {
            boolean mustContinue;
            boolean bl = mustContinue = JOptionPane.showOptionDialog(null, "Il est impossible de valider votre installation de Ofys.  Il se pourrait que vous ne soyez pas \u00e0 jour et que vous ayez rencontriez des erreurs.\nD\u00e9sirez vous quand m\u00eame lancer votre application?", "Probl\u00e8me de connectivit\u00e9", 0, 3, null, new Object[]{"Oui", "Non"}, "Non") == 0;
            if (mustContinue) {
                return true;
            }
            throw e;
        }
        catch (Exception e) {
            throw e;
        }
        return false;
    }

    protected static boolean isLauncherValid() throws Exception {
        try {
            Version local = config.getLauncherInstalledVersion();
            Version remote = config.getLauncherRemoteVersion();
            VersionDiff diff = new VersionDiff(local, remote);
            logger.log("Diff is : " + diff);
            return diff.noDiff();
        }
        catch (NoMoreDownloadProdiderException e) {
            boolean mustContinue = true;
            if (mustContinue) {
                return true;
            }
            throw e;
        }
        catch (Exception e) {
            throw e;
        }
    }

    protected static boolean haveCommand(String command) {
        return config.getCommand(command) != null;
    }

    protected static void findCommandAndExcute(String command) throws Exception {
        AbstractCommand c = config.getCommand(command);
        if (c != null) {
            logger.log("Execute command '" + c + "'");
            c.execute(config);
        }
    }

    protected static void startFrame() {
        frame = new JFrame("D\u00e9marrage d'Ofys...");
        frame.setUndecorated(true);
        ImageIcon icon2 = null;
        try {
            icon2 = new ImageIcon(ClassLoader.getSystemResource("ca/infodata/launcher3/ressources/logo.png"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        final ImageIcon icon = icon2;
        JPanel panel = new JPanel(){
            protected static final long serialVersionUID = 1L;

            @Override
            protected void paintComponent(Graphics g) {
                if (icon != null) {
                    g.drawImage(icon.getImage(), 0, 0, null);
                }
                super.paintComponent(g);
            }
        };
        panel.setOpaque(false);
        Dimension sDm = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dDm = new Dimension(615, 381);
        int x = sDm.width / 2 - dDm.width / 2;
        int y = sDm.height / 2 - dDm.height / 2;
        frame.add(panel);
        frame.setBounds(x, y, dDm.width, dDm.height);
        frame.setVisible(true);
    }

    protected static void checkVersion() throws Exception {
        boolean mustUpdateNow;
        try {
            mustUpdateNow = !Config.isInstallValid();
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error in checkVersion.mustUpdateNow check", e);
            mustUpdateNow = true;
        }
        boolean newVersionAvailable = false;
        System.out.println("VERSION_CHECK_START");
        System.out.println("newVersionAvailable=" + newVersionAvailable);
        System.out.println("mustUpdateNow=" + mustUpdateNow);
        System.out.println("VERSION_CHECK_END");
        throw new NotToSendException("Checked-Version");
    }
}

