/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.launcher3.config.command;

import ca.infodata.launcher3.config.Config;
import ca.infodata.launcher3.config.LauncherLogger;
import ca.infodata.launcher3.config.command.AbstractCommand;
import ca.infodata.launcher3.exception.NotToSendException;
import java.util.HashMap;
import java.util.Map;

public class HelpCommand2
extends AbstractCommand {
    @Override
    public String getCommandName() {
        return "-h";
    }

    @Override
    public int getMaxParameter() {
        return 0;
    }

    @Override
    public boolean isValidParameter(String value) {
        return false;
    }

    @Override
    public void execute(Config config) throws Exception {
        int maxCmdLength = 0;
        int maxParamLenth = 0;
        int spacingCmd = 8;
        int spacingParam = 12;
        int maxChar = 64;
        for (AbstractCommand ac : config.getCommandsRegister()) {
            maxCmdLength = Math.max(maxCmdLength, ac.getCommandName().length());
            for (Map.Entry<String, String> e : ac.getHelpParameters().entrySet()) {
                maxParamLenth = Math.max(maxParamLenth, e.getKey().length());
            }
        }
        LauncherLogger log = LauncherLogger.getInstance(null);
        log.log("Voici les commandes disponibles :");
        for (AbstractCommand ac : config.getCommandsRegister()) {
            String line = "  " + ac.getCommandName() + " : ";
            while (line.length() < maxCmdLength + spacingCmd) {
                line = String.valueOf(line) + " ";
            }
            String desc = ac.getHelpDescription();
            while (desc != null) {
                if (desc.length() > maxChar - maxCmdLength - spacingCmd) {
                    line = String.valueOf(line) + desc.substring(0, maxChar - maxCmdLength - spacingCmd);
                    desc = desc.substring(maxChar - maxCmdLength - spacingCmd);
                    log.log(line);
                    line = "";
                    while (line.length() < maxCmdLength + spacingCmd) {
                        line = String.valueOf(line) + " ";
                    }
                    continue;
                }
                line = String.valueOf(line) + desc;
                desc = null;
            }
            log.log(line);
            for (Map.Entry<String, String> e : ac.getHelpParameters().entrySet()) {
                line = "    " + e.getKey();
                while (line.length() < maxParamLenth + spacingParam) {
                    line = String.valueOf(line) + " ";
                }
                desc = e.getValue();
                while (desc != null) {
                    if (desc.length() > maxChar - maxParamLenth - spacingParam) {
                        line = String.valueOf(line) + desc.substring(0, maxChar - maxParamLenth - spacingParam);
                        desc = desc.substring(maxChar - maxParamLenth - spacingParam);
                        log.log(line);
                        line = "";
                        while (line.length() < maxParamLenth + spacingParam) {
                            line = String.valueOf(line) + " ";
                        }
                        continue;
                    }
                    line = String.valueOf(line) + desc;
                    desc = null;
                }
                log.log(line);
            }
        }
        log.log("\n");
        throw new NotToSendException("Help occur!");
    }

    @Override
    public String getHelpDescription() {
        return "Give help";
    }

    @Override
    public Map<String, String> getHelpParameters() {
        return new HashMap<String, String>();
    }
}

