/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.launcher3.download;

import ca.infodata.launcher.util.Util;
import ca.infodata.launcher3.download.STATUS;
import ca.infodata.launcher3.download.StringDownload;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ValidatedStringDownload
extends StringDownload {
    private static final Logger logger = Logger.getLogger(ValidatedStringDownload.class.getName());
    private String md5;
    private int md5RetryCount = 0;
    private int maxMd5RetryCount = 2;

    public ValidatedStringDownload(URL url, String description) throws MalformedURLException {
        super(url, description);
    }

    @Override
    public void run() {
        super.run();
        if (this.getStatus() == STATUS.COMPLETE) {
            try {
                String targetMd5;
                if (this.md5 != null && !(targetMd5 = Util.computeMd5(this.getBytes())).equals(this.md5)) {
                    ++this.md5RetryCount;
                    if (this.md5RetryCount < this.maxMd5RetryCount) {
                        this.getMonitor().setMessage("Erreur. fichier corrompu. Essai " + this.md5RetryCount);
                        this.run();
                    } else {
                        this.setStatus(STATUS.ERROR);
                        this.getMonitor().setMessage("Erreur. fichier corrompu. Abandon");
                    }
                }
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Failed to compute md5 of target data");
                this.setStatus(STATUS.ERROR);
            }
        }
    }

    public String getMd5() {
        return this.md5;
    }

    public void setMd5(String md5) {
        this.md5 = md5;
    }
}

