/*
 * Decompiled with CFR 0.152.
 */
package ca.infodata.stats2.client;

import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;
import java.util.logging.SimpleFormatter;

public class MedoStatsLogFormatter
extends Formatter {
    private static final String SESSION = "!SESSION";
    private static final String MESSAGE = "!MESSAGE";
    private static final String LINE_SEPARATOR = "\n";
    private SimpleDateFormat simpleDateFormat;
    private SimpleFormatter logFormatter = new SimpleFormatter();

    public MedoStatsLogFormatter() {
        this.simpleDateFormat = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss.SS");
    }

    @Override
    public String format(LogRecord record) {
        StringBuilder b = new StringBuilder(2000);
        b.append(this.getHeader());
        b.append(LINE_SEPARATOR);
        b.append(MESSAGE);
        b.append(LINE_SEPARATOR);
        b.append(this.logFormatter.format(record));
        b.append(this.formatLogParameters(record));
        return b.toString();
    }

    private String formatLogParameters(LogRecord record) {
        StringBuilder b = new StringBuilder();
        Object[] params = record.getParameters();
        if (params != null && params.length != 0) {
            b.append("Parameters\n");
            for (Object p : params) {
                b.append(this.formatParameter(p));
                b.append(LINE_SEPARATOR);
            }
        }
        return b.toString();
    }

    private String formatParameter(Object o) {
        String s = "";
        try {
            if (o == null) {
                return "null";
            }
            if (o.getClass().isArray()) {
                return Arrays.deepToString((Object[])o);
            }
            return o.toString();
        }
        catch (Exception exception) {
            return s;
        }
    }

    private String getHeader() {
        StringBuilder sb = new StringBuilder();
        sb.append(SESSION).append(" ").append(this.getDate()).append(LINE_SEPARATOR);
        try {
            String key = "java.fullversion";
            String value = System.getProperty(key);
            if (value == null) {
                key = "java.version";
                value = System.getProperty(key);
                sb.append(key + "=" + value).append(LINE_SEPARATOR);
                key = "java.vendor";
                value = System.getProperty(key);
                sb.append(key + "=" + value).append(LINE_SEPARATOR);
            } else {
                sb.append(key + "=" + value).append(LINE_SEPARATOR);
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        String os = System.getProperty("os.name");
        String arch = System.getProperty("os.arch");
        String ws = System.getProperty("sun.arch.data.model");
        String nl = System.getProperty("user.language");
        sb.append("BootLoader constants: OS=" + os);
        sb.append(", ARCH=" + arch);
        sb.append(", WS=" + ws);
        sb.append(", NL=" + nl).append(LINE_SEPARATOR);
        return sb.toString();
    }

    private synchronized String getDate() {
        try {
            return this.simpleDateFormat.format(new Date());
        }
        catch (Exception exception) {
            return Long.toString(System.currentTimeMillis());
        }
    }
}

